<?php
if(!defined('BASEPATH')) {
   die('Direct access to the script is not allowed');
}
if( $admin["access"]["admin_access"] != 1  ){

    header("Location:".site_url("admin"));

    exit();
}

$statuses = ['pending', 'inprogress', 'completed', 'partial', 'processing', 'canceled'];
$orderCounts = [];

foreach ($statuses as $status) {
    $stmt = $conn->prepare("SELECT COUNT(*) FROM orders WHERE order_status = :status");
    $stmt->execute(['status' => $status]);
    $orderCounts[$status] = $stmt->fetchColumn();
}



  $clients = $conn->prepare("SELECT * FROM clients ORDER BY client_id DESC LIMIT 500");
  $clients->execute(array());
  $clients = $clients->fetchAll(PDO::FETCH_ASSOC);

  $failCount      = $conn->prepare("SELECT * FROM orders WHERE orders.dripfeed='1' && orders.subscriptions_type='1' && order_error!=:error ");
  $failCount     -> execute(array("error"=>"-"));
  $failCount      = $failCount->rowCount();
  $todayCount      = $conn->prepare("SELECT * FROM orders WHERE last_check=:error ");
  $todayCount     -> execute(array("error"=> date("Y-m-d") ));
  $todayCount     = $todayCount->rowCount();



$stmt = $conn->prepare("SELECT o.*, c.username, s.service_name 
    FROM orders o
    LEFT JOIN clients c ON o.client_id = c.client_id
    LEFT JOIN services s ON o.service_id = s.service_id
    ORDER BY o.order_create DESC
    LIMIT 10");
$stmt->execute();
$recentOrders = $stmt->fetchAll(PDO::FETCH_ASSOC);


$stmt = $conn->prepare("SELECT p.*, c.username, m.methodVisibleName 
    FROM payments p
    LEFT JOIN clients c ON p.client_id = c.client_id
    LEFT JOIN paymentmethods m ON p.payment_method = m.methodId
    ORDER BY p.payment_create_date DESC
    LIMIT 5");
$stmt->execute();
$recentPayments = $stmt->fetchAll(PDO::FETCH_ASSOC);


$stmt = $conn->prepare("
    SELECT s.service_id, s.service_name, COUNT(o.order_id) AS total_orders
    FROM orders o
    JOIN services s ON o.service_id = s.service_id
    GROUP BY s.service_id
    ORDER BY total_orders DESC
    LIMIT 1
");
$stmt->execute();
$mostPopularService = $stmt->fetch(PDO::FETCH_ASSOC);




function time_elapsed_string($datetime, $full = false) {
    $now = new DateTime;
    $ago = new DateTime($datetime);
    $diff = $now->diff($ago);
    $diff->w = floor($diff->d / 7);
    $diff->d -= $diff->w * 7;
    $string = [
        'y' => 'year', 'm' => 'month', 'w' => 'week',
        'd' => 'day', 'h' => 'hour', 'i' => 'minute', 's' => 'second',
    ];
    foreach ($string as $k => &$v) {
        if ($diff->$k) $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
        else unset($string[$k]);
    }
    return $string ? implode(', ', array_slice($string, 0, 1)) . ' ago' : 'just now';
}

function payment_status_text($status) {
    switch ($status) {
        case '1': return 'Pending';
        case '2': return 'Pending';
        case '3': return 'Completed';
        default: return 'Unknown';
    }
}

function payment_status_class($status) {
    switch ($status) {
        case '1': return 'pending';
        case '2': return 'Pending';
        case '3': return 'Completed';
        default: return '';
    }
}



if( route(2) && is_numeric(route(2)) ):
  $page = route(2);
else:
  $page = 1;
endif;

if( $_GET["search_type"] == "username" && $_GET["search"] ):
  $search_where = $_GET["search_type"];
  $search_word  = urldecode($_GET["search"]);
  $clients      = $conn->prepare("SELECT client_id FROM clients WHERE username LIKE '%".$search_word."%' ");
  $clients     -> execute(array());
  $clients      = $clients->fetchAll(PDO::FETCH_ASSOC);
  $id=  "("; foreach ($clients as $client) { $id.=$client["client_id"].","; } if( substr($id,-1) == "," ):  $id = substr($id,0,-1); endif; $id.=")";
  $search       = " client_report.client_id IN ".$id;
  $count        = $conn->prepare("SELECT * FROM client_report INNER JOIN clients ON clients.client_id=client_report.client_id WHERE {$search} ");
  $count        -> execute(array());
  $count        = $count->rowCount();
  $search       = "WHERE {$search} ";
  $search_link  = "?search=".$search_word."&search_type=".$search_where;
elseif( $_GET["search_type"] == "action" && $_GET["search"] ):
  $search_where = $_GET["search_type"];
  
  $search_word  = urldecode($_GET["search"]);
  $count        = $conn->prepare("SELECT * FROM client_report INNER JOIN clients ON clients.client_id=client_report.client_id WHERE client_report.action LIKE '%".$search_word."%' ");
  $count        -> execute(array());
  $count        = $count->rowCount();
  $search       = "WHERE client_report.action LIKE '%".$search_word."%' ";
  $search_link  = "?search=".$search_word."&search_type=".$search_where;
else:
  $count          = $conn->prepare("SELECT * FROM client_report INNER JOIN clients ON clients.client_id=client_report.client_id ");
  $count        ->execute(array());
  $count          = $count->rowCount();
  $search         = "";
endif;

  $to             = 50;
  $pageCount      = ceil($count/$to); if( $page > $pageCount ): $page = 1; endif;
  $where          = ($page*$to)-$to;
  $paginationArr  = ["count"=>$pageCount,"current"=>$page,"next"=>$page+1,"previous"=>$page-1];
  $logs = $conn->prepare("SELECT * FROM client_report INNER JOIN clients ON clients.client_id=client_report.client_id $search ORDER BY client_report.id DESC LIMIT $where,$to ");
  $logs->execute(array());
  $logs = $logs->fetchAll(PDO::FETCH_ASSOC);

  if( route(2) == "delete" ):
    $id     = route(3);
    $delete = $conn->prepare("DELETE FROM client_report WHERE id=:id ");
    $delete->execute(array("id"=>$id));
    header("Location:".site_url("admin/index"));
  elseif( route(2) == "multi-action" ):
    $logs     = $_POST["log"];
    $action   = $_POST["bulkStatus"];
    foreach ($logs as $id => $value):
      $delete = $conn->prepare("DELETE FROM client_report WHERE id=:id ");
      $delete->execute(array("id"=>$id));
    endforeach;
    header("Location:".site_url("admin/index"));
  endif;





  

require admin_view('index');