<div class="col-md-8">
  <div class="panel panel-default">
    <div class="panel-heading text-center">
      <h4>CRONJOBS FOR CPANEL</h4>
    </div>
    <div class="panel-body">

      <p class="text-info"><strong>Copy one by one then setup in your hosting cPanel Cronjobs!</strong></p>

      <!-- Cron Job Items -->
      <div class="form-group">
        <label for="cron_orders">Orders:</label>
        <div class="input-group">
          <input type="text" class="form-control cron_job" id="cron_orders" readonly value="wget --spider -O - https://yourdomain.com/automations/cronjobs/orders.php">
          <span class="input-group-btn">
            <button class="btn btn-primary copy-btn" type="button" data-target="#cron_orders">Copy</button>
          </span>
        </div>
      </div>

      <div class="form-group">
        <label for="cron_dripfeed">Drip-Feed:</label>
        <div class="input-group">
          <input type="text" class="form-control cron_job" id="cron_dripfeed" readonly value="wget --spider -O - https://Your_Domin/automations/cronjobs/dripfeed.php">
          <span class="input-group-btn">
            <button class="btn btn-primary copy-btn" type="button" data-target="#cron_dripfeed">Copy</button>
          </span>
        </div>
      </div>

      <div class="form-group">
        <label for="cron_refill">Refill:</label>
        <div class="input-group">
          <input type="text" class="form-control cron_job" id="cron_refill" readonly value="wget --spider -O - https://Your_Domin/automations/cronjobs/refill.php">
          <span class="input-group-btn">
            <button class="btn btn-primary copy-btn" type="button" data-target="#cron_refill">Copy</button>
          </span>
        </div>
      </div>

      <div class="form-group">
        <label for="cron_sellersync">Seller Sync:</label>
        <div class="input-group">
          <input type="text" class="form-control cron_job" id="cron_sellersync" readonly value="wget --spider -O - https://Your_Domin/automations/cronjobs/seller-sync.php">
          <span class="input-group-btn">
            <button class="btn btn-primary copy-btn" type="button" data-target="#cron_sellersync">Copy</button>
          </span>
        </div>
      </div>

      <div class="form-group">
        <label for="cron_avgtime">Average Time:</label>
        <div class="input-group">
          <input type="text" class="form-control cron_job" id="cron_avgtime" readonly value="wget --spider -O - https://Your_Domin/automations/cronjobs/average.php">
          <span class="input-group-btn">
            <button class="btn btn-primary copy-btn" type="button" data-target="#cron_avgtime">Copy</button>
          </span>
        </div>
      </div>

    </div>
  </div>
</div>

<script>
  // Current domain
  const currentDomain = window.location.hostname;

  // Update all cron_job inputs
  document.querySelectorAll('.cron_job').forEach(input => {
    input.value = input.value.replace(/https:\/\/(yourdomain\.com|Your_Domin)/, `https://${currentDomain}`);
  });

  // Copy functionality
  document.querySelectorAll('.copy-btn').forEach(btn => {
    btn.addEventListener('click', function() {
      const target = document.querySelector(this.dataset.target);
      target.select();
      target.setSelectionRange(0, 99999); // Mobile support
      document.execCommand("copy");
      alert("Copied: " + target.value);
    });
  });
</script>

<style>
  .panel-heading {
    background-color: #007bff;
    color: #fff;
    font-weight: bold;
  }
  .cron_job {
    font-family: monospace;
    color: #333;
  }
  .input-group-btn .btn {
    border-radius: 0 4px 4px 0;
  }
</style>
