<?php
$path = __DIR__ . '/last_cron_run.txt';

if (file_exists($path)) {
    $lastRun = file_get_contents($path);
    $lastTime = strtotime($lastRun);
    $now = time();
    $diff = $now - $lastTime;

    $status = $diff <= 600 ? 'working' : 'stopped'; 
    echo json_encode([
        'status' => $status,
        'last_run' => $lastRun
    ]);
} else {
    echo json_encode([
        'status' => 'never',
        'last_run' => null
    ]);
}
