<?php
ini_set('max_execution_time', '600');
define("BASEPATH",TRUE);
require $_SERVER["DOCUMENT_ROOT"]."/vendor/autoload.php";
require $_SERVER["DOCUMENT_ROOT"]."/app/init.php";


$smmapi = new SMMApi();

// Refill status processing
$refills = $conn->prepare("SELECT * FROM tasks WHERE task_type=:type");
$refills->execute(array("type"=>1));
$refills = $refills->fetchAll(PDO::FETCH_ASSOC);

foreach ($refills as $refill) {
    if($refill["check_refill_status"] == 2) {
        $order_id_refill = $refill['order_id'];
        $refill_apiid = $refill["task_api"];
        $task_id = $refill["task_id"];
        $refill_id = $refill["refill_orderid"];
        
        $order = $conn->prepare("SELECT * FROM orders INNER JOIN services ON services.service_id = orders.service_id INNER JOIN service_api ON services.service_api = service_api.id WHERE orders.order_id=:id");
        $order->execute(array("id"=>$order_id_refill));
        $order = $order->fetch(PDO::FETCH_ASSOC);
        $order = json_decode(json_encode($order),true);

        $refill_apiurl = $order["api_url"]; 
        $get_refill_status = $smmapi->action(array(
            'key' => $order["api_key"],
            'action' => 'refill_status',
            'refill' => $refill_id
        ), $refill_apiurl);

        $status = $get_refill_status->status;

        if($status == "Rejected") {
            $task_status = "rejected";
            $check_refill_status = 1; 
        } elseif ($status == "Completed") {
            $task_status = "completed";
            $check_refill_status = 1; 
        } else {
            $task_status = "inprogress";
            $check_refill_status = 2; 
        }

        if(empty($refill_id) || $refill_id == null) {
            $task_status = "completed";
            $check_refill_status = 1;
        }

        $update = $conn->prepare("UPDATE tasks SET task_status=:status,task_updated_at=:updated_at,check_refill_status=:check_refill_status WHERE task_id=:id");
        $update->execute(array(
            "status" => $task_status,
            "updated_at" => date('Y.m.d H:i:s'),
            "check_refill_status" => $check_refill_status,
            "id" => $task_id
        ));
    }
}

// Cancel order processing
$cancel_orders = $conn->prepare("SELECT * FROM tasks WHERE task_status=:status && task_type=:type");
$cancel_orders->execute(array(
    "status" => "inprogress",
    "type" => 2
));
$cancel_orders = $cancel_orders->fetchAll(PDO::FETCH_ASSOC);

foreach($cancel_orders as $cancel) {
    if($cancel["check_refill_status"] == 2) {
        $cancel_api_response = json_decode($cancel["task_response"],true);

        if($cancel_api_response["status"] == "Success" || $cancel_api_response["status"] == "success") {
            $update = $conn->prepare("UPDATE tasks SET task_status=:status,check_refill_status=:check WHERE task_type=:type");
            $update->execute(array(
                "status" => "canceled",
                "check" => 1,
                "type" => 2
            ));
        } else {
            $update = $conn->prepare("UPDATE tasks SET task_status=:status,check_refill_status=:check WHERE task_type=:type");
            $update->execute(array(
                "status" => "failed",
                "check" => 1,
                "type" => 2
            ));
        }
    }
}